<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:300i,400,700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css">
    <style>
    @media print {
        .no-print, .no-print * {
            display: none !important;
        }
        .print-class-header {
            display: block !important;
            font-weight: bold;
            font-size: 20px;
            margin-bottom: 5px;
            page-break-before: always;
        }
        .print-page-header {
        display: block !important;
        position: relative;
        font-weight: bold;
        font-size: 16px;
        margin-bottom: 5px;
    }
    body, .container {
        padding-top: 30px;
    }
    }

    @media screen {
        .print-class-header {
            display: none;
        }
        .print-page-header {
        display: none;
    }
    }
</style>

</head>
<body>
    <h3 style="text-align: center; background-color: rgba(0, 0, 0, 0.2); padding: 10px; overflow-x: auto; color: black;">
        Payment Details Report <?php echo $type; ?> Wise
    </h3>
    <?php
    date_default_timezone_set('Asia/Dhaka');
    ?>
    <div style="background-color: rgba(0, 0, 0, 0.2); padding: 10px; margin-top: 10px; overflow-x:auto;">
        <p style="position: relative;">
            <?php echo $head; ?>
            <span class="no-print" style="right: 0;margin-left: 554px;">Report Time: <?php echo $date = date('d-m-Y h:i A'); ?></span>
        </p>

        <table class="table table-bordered table-striped">

            <tbody>
                <?php
                // Sort class order logically
                $class_order = [
                    'NURSERY' => 0, 'KG' => 0.5, 'PLAY' => 0.2,
                    'ONE' => 1, 'TWO' => 2, 'THREE' => 3, 'FOUR' => 4, 'FIVE' => 5,
                    'SIX' => 6, 'SEVEN' => 7, 'EIGHT' => 8, 'NINE' => 9, 'TEN' => 10,
                    'ELEVEN' => 11, 'TWELVE' => 12
                ];

                if ($type == 'Student') {
                    // Sort classes logically
                    uksort($show_data, function ($a, $b) use ($class_order) {
                        return ($class_order[$a] ?? 99) <=> ($class_order[$b] ?? 99);
                    });

                    foreach ($show_data as $class => $sections) {
                      
                        ksort($sections);

                        $section_counter = 0;

                    foreach ($sections as $section => $students) {
                        $section_counter++;
                        $page_break_style = ($section_counter > 1) ? "page-break-before: always;" : "";
                    
                        echo "<tr style='$page_break_style'>
                                <td colspan='" . count($table_row) . "'>
                                    <p class='print-page-header'>
                                        $head
                                        <span class='no-print' style='position: absolute; right: 0;'>Report Time: " . date('d-m-Y h:i A') . "</span>
                                    </p>
                                </td>
                              </tr>";
                      
                        echo "<tr style='background:#f8f9fa; font-weight: bold; color: black;'>
                            <td colspan='" . count($table_row) . "'>
                                Class: $class, Section: $section
                            </td>
                          </tr>";
                                        
                                            
                        echo "<tr class='table-dark'>";
                    foreach ($table_row as $key => $header) {
                        $align = ($key == count($table_row) - 1) ? 'right' : 'center';
                        echo "<th style='text-align: $align;'>$header</th>";
                    }
                    echo "</tr>";
                    
                        
                        $total_students = count($students);
                        $counter = 0;
                    
                       
                        foreach ($students as $data_array) {
                            $counter++;
                            
                            $page_break_style = ($counter == $total_students) ? 'page-break-after: always;' : '';
                    
                            echo "<tr style='$page_break_style'>";
                            foreach ($data_array as $key => $data) {
                                $align = ($key == count($data_array) - 1) ? 'right' : 'center';
                                if ($align == 'right') {
                                    $data = number_format((float)$data, 2, '.', '');
                                }
                                echo "<td style='text-align: $align;'>$data</td>";
                            }
                            echo "</tr>";
                        }
                    }

                    }
                } else {
                    
                    echo "<tr style='background:#343a40; color: white;'>";
                    foreach ($table_row as $key => $header) {
                        $align = ($key == count($table_row) - 1) ? 'right' : 'center';
                        echo "<th style='text-align: $align;'>$header</th>";
                    }
                    echo "</tr>";

                    foreach ($show_data as $data_array) {
                        echo "<tr>";
                        foreach ($data_array as $key => $data) {
                            $align = ($key == count($data_array) - 1) ? 'right' : 'center';
                            if ($align == 'right') {
                                $data = number_format((float)$data, 2, '.', '');
                            }
                            echo "<td style='text-align: $align;'>$data</td>";
                        }
                        echo "</tr>";
                    }
                }
                ?>

                <tr>
                    <th colspan="<?php echo count($table_row) - 1; ?>" style="text-align: center;">Total</th>
                    <th style="text-align: right;"><?php echo number_format((float)$total, 2, '.', ''); ?></th>
                </tr>
            </tbody>
        </table>
    </div>
</body>
</html>
