<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:300i,400,700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css">
   <style>
    table, th, td {
        border: 1px solid black;
        border-collapse: collapse;
    }

    @media print {
        .no-print, .no-print * {
            display: none !important;
        }
        .print-header {
            position: fixed;
            top: 0;
            width: 100%;
            padding: 10px 0;
            background: white;
            font-size: 16px;
        }
        .page-break {
            page-break-after: always;
        }
        .group-title {
            font-weight: bold;
            font-size: 18px;
            text-align: center;
            margin: 20px 0;
        }
    }
</style>

</head>
<body>

    <h3 style="text-align: center;background-color: rgba(0, 0, 0, 0.2);padding: 10px;overflow-x:auto;color: black;">
        Due Report <?php echo $type; ?> Wise 
    </h3>

    <div style="background-color: rgba(0, 0, 0, 0.2); padding: 10px; margin-top: 10px; overflow-x:auto;">
        
        <?php
        date_default_timezone_set('Asia/Dhaka');
        // Step 1: Group data by class and section
        $grouped_data = [];
        foreach ($show_data as $data) {
            $class = $data[4];
            $section = $data[5];
            $grouped_data[$class][$section][] = $data;
        }

        $total = 0; // Initialize grand total
        $first = true; // Track first group
        ?>

        <?php foreach ($grouped_data as $class => $sections): ?>
            <?php foreach ($sections as $section => $students): ?>

                <?php if (!$first): ?>
                    <div class="page-break"></div>
                <?php endif; ?>
                <?php $first = false; ?>

                <!-- Header per page -->
                <p style="position: relative;">
                    <?php echo $head; ?>
                    <span style="position: absolute; right: 0;">
                        Report Time: <?php echo date('d-m-Y h:i A'); ?>
                    </span>
                </p>

                <div class="group-title">
                    Class: <?= h($class) ?> &nbsp; | &nbsp; Section: <?= h($section) ?>
                </div>

                <table border="1" width="100%" cellpadding="5" cellspacing="0">
                    <thead>
                        <tr>
                            <th style="text-align: center;">SL</th>
                            <?php foreach ($table_row as $header): ?>
                                <th style="text-align: center;"><?= h($header) ?></th>
                            <?php endforeach; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $sl = 1;
                        $group_total = 0;
                        foreach ($students as $data_array): ?>
                            <tr>
                                <td style="text-align: center;"><?= $sl++ ?></td>
                                <?php foreach ($data_array as $key => $data): 
                                    $align = 'center';
                                    if ($key == count($data_array) - 1) {
                                        $align = 'right';
                                        $data = number_format((float)$data, 2, '.', '');
                                        $group_total += (float)$data;
                                    }
                                ?>
                                    <td style="text-align: <?= $align ?>;"> <?= h($data) ?> </td>
                                <?php endforeach; ?>
                            </tr>
                        <?php endforeach; ?>
                        <tr>
                            <th style="text-align: center;" colspan="7">Group Total</th>
                            <th style="text-align: right;"><?= number_format($group_total, 2, '.', '') ?></th>
                        </tr>
                    </tbody>
                </table>

                <?php $total += $group_total; ?>
            <?php endforeach; ?>
        <?php endforeach; ?>

        <!-- Final grand total -->
        <div class="group-title">
            <strong>Grand Total: <?= number_format($total, 2, '.', '') ?></strong>
        </div>
    </div>

</body>
</html>
