
<?php
use Cake\Core\Configure;
use Cake\Http\ServerRequest;

// Provide a separate title block for use in AJAX (JavaScript)
$this->start('ajaxTitle');
echo 'SID Search';
$this->end();
?>

<title><?= h($this->fetch('title')) ?></title>




<style>
    .topSubmittable {
        font-size: 22px;
        font-weight: 600;
        border-bottom: 2px solid #862424;
        padding-bottom: 0.25em;
    }

    .submitBox {
        padding: 3em;
        text-align: justify;
        background-color: rgb(251, 251, 251);
        box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
        border-bottom: 4px solid rgb(17, 128, 192);
        margin-top: 10px !important;
    }

    .submitForm {
        border-radius: 0 !important;
        padding: 0.5em 1em !important;
        background-color: #fff !important;
        color: #000 !important;
    }

    .label {
        font-weight: bold;
    }
    .student-info-box {
    width: 400px;
    margin: 20px auto;
    padding: 20px 25px;
    border: 2px solid #1169c0; /* blue border */
    background-color: #f0f8ff; /* very light blue */
    border-radius: 8px;
    box-shadow: 0 4px 8px rgba(17, 105, 192, 0.2);
    font-family: Arial, sans-serif;
}

.student-info-box span.label {
    font-weight: bold;
    color: #1169c0;
    display: inline-block;
    width: 110px;
}

.student-info-box span.value {
    color: #333;
    font-weight: bold;
}
</style>

<?php if ($siteTemplate == 2) { ?>
<div class="container my-3">
<?php } else { ?>
<div>
<?php } ?>

<?= $this->Form->unlockField('section_id') ?>
<?= $this->Form->create(null, ['action' => 'getSid']) ?>

<div class="submitBox">
    <?php if (!empty($validationErrors)) : ?>
        <div class="error-message" style="color:#fff;padding:15px; background:#F99;margin:0 0 10px">
            <?= empty($validationErrors['pErr']) ? 'Please fill up the form correctly!' : $validationErrors['pErr'] ?>
        </div>
    <?php endif; ?>

    <div class="row">

        <!-- Session -->
        <div class="col-md-3">
            <div class="form-group">
                <?= $this->Form->control('session_id', [
                    'label' => ['text' => 'Session', 'class' => 'label'],
                    'options' => \Cake\Utility\Hash::combine($sessions, '{n}.session_id', '{n}.session_name'),
                    'empty' => '-- Choose --',
                    'class' => 'form-control submitForm',
                    'required' => true,
                ]) ?>
            </div>
        </div>

        <!-- Class -->
        <div class="col-md-3">
            <div class="form-group">
                <?= $this->Form->control('level_id', [
                    'label' => ['text' => 'Class', 'class' => 'label'],
                    'options' => \Cake\Utility\Hash::combine($levels, '{n}.level_id', '{n}.level_name'),
                    'empty' => '-- Choose --',
                    'class' => 'form-control submitForm',
                    'required' => true,
                    'id' => 'level_id'
                ]) ?>
            </div>
        </div>

        <!-- Section -->
        <div class="col-md-3">
            <div class="form-group">
                <label class="label" for="section_id">Section</label>
                <select name="section_id" id="section_id" class="form-control submitForm" required>
                    <option value="">-- Choose --</option>
                    <!-- Sections will be loaded via AJAX -->
                </select>
            </div>
        </div>

        <!-- Roll -->
        <div class="col-md-3">
            <div class="form-group">
                <?= $this->Form->control('roll', [
                    'label' => ['text' => 'Roll', 'class' => 'label'],
                    'class' => 'form-control submitForm',
                    'placeholder' => 'Enter Roll Number',
                    'required' => true
                ]) ?>
            </div>
        </div>

        <!-- Submit -->
        <div class="col-md-12">
            <div class="form-group text-center">
                <?= $this->Form->submit('SUBMIT', ['class' => 'btn btn-lg btn-success']) ?>
            </div>
        </div>
    </div>
</div>

<?= $this->Form->end(); ?>
</div>

<?php
if ($this->request->is('post')) {
    if (!empty($student)) {
        // Student found
        ?>
        <div class="student-info-box">
            <div><span class="label">Name:</span> <span class="value"><?= h($student['name']) ?></span></div>
            <div><span class="label">Student ID:</span> <span class="value"><?= h($student['sid']) ?></span></div>
        </div>
        <?php
    } else {
        // Search performed, but student not found
        ?>
        <div class="alert alert-danger">
            Your search is incorrect. Please try again.
        </div>
        <?php
    }
}
?>

<!-- AJAX for Section Load -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    // When level changes
    $('#level_id').change(function() {
        var levelId = $(this).val();
        
        // Clear existing options
        $('#section_id').html('<option value="">-- Choose --</option>');
        
        if (levelId) {
            // Make AJAX request to get sections for the selected level and session
            $.ajax({
                url: 'getSecAjax',
                type: 'GET',
                data: {
                    level_id: levelId,
                },
                dataType: 'json',
                success: function(response) {
    if (Array.isArray(response) && response.length > 0) {
        var options = '<option value="">-- Choose --</option>';
        $.each(response, function(key, section) {
            options += '<option value="' + section.section_id + '">' + section.section_name + '</option>';
        });
        $('#section_id').html(options);
    } else {
        alert('No sections found for this class');
    }
}
            });
        }
    });
    
});
</script>


<script>
document.addEventListener("DOMContentLoaded", function () {
    var pageTitle = <?= json_encode($this->fetch('ajaxTitle')) ?>;
    if (pageTitle) {
        document.title = pageTitle + ' - <?= addslashes(Configure::read('Site.title') ?? 'My Site') ?>';
    }
});
</script>



