<?php

use Cake\Core\Configure;

$siteTemplate = Configure::read('Site.template');
$paymentImage = Configure::read('Site.PaymentImage');
$paymentNote = Configure::read('Site.paymentNote');

if ($siteTemplate == 2) {
    $this->layout = 'default';
} else {
    $this->layout = 'no_sidebar';
}
?>

<style>
    .success-container {
        max-width: 600px;
        margin: 30px auto;
        background: #ffffff;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        padding: 25px 30px;
        font-family: "Segoe UI", Tahoma, sans-serif;
        text-align: center;
        border-top: 6px solid #28a745;
    }

    .success-header {
        font-size: 20px;
        font-weight: 700;
        color: #28a745;
        margin-bottom: 25px;
    }

    .student-photo {
        margin: 15px 0;
    }

    .student-photo img {
        width: 142px;
        height: 132px;
        border-radius: 10px;
        border: 2px solid #ddd;
        object-fit: cover;
        box-shadow: 0 3px 8px rgba(0, 0, 0, 0.1);
    }

    .student-info {
        margin-top: 20px;
        text-align: left;
    }

    .student-info div {
        margin-bottom: 10px;
        font-size: 15px;
    }

    .student-info strong {
        color: #333;
        display: inline-block;
        width: 140px;
    }

    .btn-custom {
        display: inline-block;
        margin-top: 25px;
        padding: 10px 20px;
        background: #007bff;
        color: #fff;
        font-size: 14px;
        font-weight: 600;
        border-radius: 6px;
        text-decoration: none;
        transition: 0.3s;
    }

    .btn-custom:hover {
        background: #0056b3;
        text-decoration: none;
        color: #fff;
    }
</style>

<?php if ($siteTemplate == 2) { ?>
    <div>
        <div>
        <?php } else { ?>

            <div class="success-container">
                <div class="success-header">
                    Congratulations! Your registration is successful.
                </div>

                <div class="student-photo">
                    <?= $this->Html->image(
                        '/webroot/uploads/students/thumbnail/' . $student['thumbnail'],
                        ['alt' => 'Student Photo']
                    ); ?>
                </div>

                <div class="student-info">
                    <div><strong>Student Name:</strong> <?= h($student['name_english']); ?></div>
                    <div><strong>Father’s Name:</strong> <?= h($student['fname']); ?></div>
                    <div><strong>Mother’s Name:</strong> <?= h($student['mname']); ?></div>
                    <div><strong>Class:</strong> <?= h($student['level']); ?></div>
                </div>

                <?= $this->Html->link(
                    '📄 Download Application Copy',
                    ['controller' => 'Admission', 'action' => 'applicationCopy', $student['id']],
                    ['class' => 'btn-custom', 'target' => '_blank']
                ); ?>
            </div>

        <?php } ?>