<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Document</title>
</head>

<body>

	<div class="rows">
		<h3 class="text-center"><?= __d('accounts', 'All Penalty') ?></h3>

		<span
			class="text-right float-right mb-3"><?= $this->Html->link('Add Penalty', ['action' => 'addPenalty'], ['class' => 'btn btn-info']) ?></span>

	</div>
	<div class="table-responsive-sm">
		<table class="table table-bordered table-striped">
			<thead class="thead-dark">
				<tr>
					<th><?= __d('accounts', 'ID') ?></th>
					<th><?= __d('accounts', 'Session') ?></th>
					<th><?= __d('accounts', 'Level') ?></th>
					<th><?= __d('accounts', 'Purpose') ?></th>
					<th><?= __d('accounts', 'Amount') ?> </th>
					<th><?= __d('accounts', 'Action') ?></th>

				</tr>
			</thead>
			<tbody>
				<?php
				foreach ($penalties as $penalty) {
					?>
					<tr>
						<td><?= $penalty['id'] ?></td>
						<td><?= $penalty['session_name'] ?></td>
						<td><?= $penalty['level_name'] ?></td>
						<td><?= $penalty['purpose_name'] ?></td>
						<td class=""><?= number_format($penalty['amount'], 2, '.', ''); ?></td>
						<td>
							<?= $this->Html->link('Edit', ['action' => 'editPenalty', $penalty['id']], ['class' => 'btn action-btn btn-warning']) ?>
							<?= $this->Form->postLink('Delete', ['action' => 'deletePenalty', $penalty['id']], ['class' => 'btn action-btn btn-danger', 'confirm' => 'Are you sure, You want delete this?']) ?>

						</td>
					</tr>
				<?php } ?>

			</tbody>
		</table>
	</div>
</body>

</html>