<?php

$this->Form->unlockField('purpose_id'); ?>
<?php $this->Form->unlockField('amount'); ?>
<div>
	<?= $this->Form->create(); ?>
	<section>
		<h4><?= __d('accounts', 'Edit Penalty') ?></h4>
		<div class="row mx-3 mt-2 p-3 form-box">

			<div class="col-md-6 col-12 mt-1">
				<label for="inputState" class="form-label"><?= __d('accounts', 'Session') ?></label>
				<select id="session_id" class="form-select option-class" name="session_id" disabled>
					<?php foreach ($sessions as $session) { ?>
						<option value="<?= $session->session_id; ?>" <?php if ($session->session_id == $penalty[0]['session_id']) {
							  echo 'selected';
						  } ?>>
							<?= $session->session_name; ?>
						</option>
					<?php } ?>
				</select>
			</div>
			<div class="col-md-6 col-12 mt-1">
				<label for="inputState" class="form-label"><?= __d('accounts', 'Level') ?></label>
				<select id="level_id" class="form-select option-class" name="level_id" disabled>
					<?php foreach ($levels as $level) { ?>
						<option value="<?= $level->level_id; ?>" <?php if ($level->level_id == $penalty[0]['level_id']) {
							  echo 'selected';
						  } ?>>
							<?= $level->level_name; ?>
						</option>
					<?php } ?>

				</select>
			</div>
			<div class="col-md-6 col-12 mt-2">
				<label for="inputState" class="form-label"><?= __d('accounts', 'Purpose') ?></label>
				<select id="inputState" class="form-select option-class" name="purpose_id" required>
					<option value=""><?= __d('accounts', 'Choose...') ?></option>
					<?php foreach ($options as $value => $text) { ?>
						<option value="<?= $value ?>" <?php if ($value == $penalty[0]['purpose_id']) {
							  echo 'selected';
						  } ?>><?= h($text) ?></option>
					<?php } ?>
				</select>
			</div>
			<div class="col-md-6 col-12 mt-1">
				<label class="form-label"><?= __d('accounts', 'Amount') ?></label>
				<input name="amount" value="<?php echo $penalty[0]['amount'] ?>" type="number" class="form-control"
					placeholder="Enter Amount..." required>
			</div>
		</div>
	</section>

	<div class="text-right mt-5">
		<button type="submit" class="btn btn-info text-light"><?= __d('accounts', 'Submit') ?></button>
		<?= $this->Html->Link('Back', ['action' => 'purposes'], ['class' => 'btn ']); ?>
		<?= $this->Form->end(); ?>
	</div>
</div>
<script type="text/javascript">
	$("#session_id").change(function () {
		var session_id = $("#session_id").val();
		$.ajax({
			url: 'getLevelFromSessionAjax',
			cache: false,
			type: 'GET',
			dataType: 'HTML',
			data: {
				"session_id": session_id
			},
			success: function (data) {
				data = JSON.parse(data);
				var text1 = '<option value="">-- Choose --</option>';
				for (let i = 0; i < data.length; i++) {
					var name = data[i]["level_name"];
					var id = data[i]["level_id"];
					text1 += '<option value="' + id + '" >' + name + '</option>';
				}
				$('#level_id').html(text1);
			}
		});
	});
</script>