<?php

namespace Croogo\Core\Controller\Api;

use Cake\Core\Configure;
use Cake\Event\Event;
use Cake\Http\Response;
use Cake\Http\ResponseEmitter;
use Cake\Http\ServerRequest;
use Croogo\Core\Croogo;
use Cake\Datasource\ConnectionManager;
use DateTime;
use Croogo\Core\Controller\Api\AppController;
use Cake\ORM\TableRegistry;


class OnlinePaymentController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->autoRender = false;
        $this->viewBuilder()->disableAutoLayout();

    }

    public function feeInfo()
    {
        if ($this->request->is(['post'])) {
            $data = $this->request->getData();
            $gateway_info = $this->get_gateway_info($data['userId']);
            if (count($gateway_info)) {
                $instituteName = $this->get_settings_value('Site.title');
                $password = $gateway_info[0]['mfs_key'] . $data['random'] . $data['referenceId'];
                if ($data['userId'] == $gateway_info[0]['user_id'] && $data['password'] == hash("sha512", $password)) {
                    $studnet_data = $this->get_student_data($data['referenceId']);
                    if ($studnet_data == -1) {
                        $return_data = [
                            'referenceId' => null,
                            'dateTime' => date('d/m/Y H:i A'),
                            'responseCode' => 90,
                            'responseMsg' => 'This Student Has No Due',
                            'feeDetails' => [
                                'studentId' => null,
                                'instituteName' => $instituteName,
                                'branchName' => null,
                                'shift' => null,
                                'className' => null,
                                'sectionName' => null,
                                'invoiceNo' => null,
                                'studentName' => null,
                                'fatherName' => null,
                                'month' => null,
                                'academicYear' => null,
                                'fee' => null,
                                'waiver' => null,
                                'totalDue' => null,
                            ]
                        ];
                    } else {
                        $return_data = [
                            'referenceId' => $data['referenceId'],
                            'dateTime' => date('d/m/Y H:i A'),
                            'responseCode' => '00',
                            'responseMsg' => 'SUCCESS',
                            'feeDetails' => [
                                'studentId' => $studnet_data['student_sid'],
                                'instituteName' => $instituteName,
                                'branchName' => null,
                                'shift' => null,
                                'className' => $studnet_data['level_name'],
                                'sectionName' => $studnet_data['section_name'],
                                'invoiceNo' => $studnet_data['voucher_no'],
                                'studentName' => $studnet_data['name'],
                                'fatherName' => $studnet_data['father_name'],
                                'month' => $studnet_data['months_name'],
                                'academicYear' => $studnet_data['session_name'],
                                'fee' => $studnet_data['amount'],
                                'waiver' => 0,
                                'totalDue' => $studnet_data['amount'],
                            ]
                        ];
                    }
                } else {
                    $return_data = [
                        'referenceId' => null,
                        'dateTime' => date('d/m/Y H:i A'),
                        'responseCode' => 90,
                        'responseMsg' => 'Username and Password do not match',
                        'feeDetails' => [
                            'studentId' => null,
                            'instituteName' => null,
                            'branchName' => null,
                            'className' => null,
                            'sectionName' => null,
                            'invoiceNo' => null,
                            'studentName' => null,
                            'fatherName' => null,
                            'month' => null,
                            'academicYear' => null,
                            'fee' => null,
                            'waiver' => null,
                            'totalDue' => null,
                        ]
                    ];
                }

            } else {
                $return_data = [
                    'referenceId' => null,
                    'dateTime' => date('d/m/Y H:i A'),
                    'responseCode' => 90,
                    'responseMsg' => 'Username and Password do not match',
                    'feeDetails' => [
                        'studentId' => null,
                        'instituteName' => null,
                        'branchName' => null,
                        'className' => null,
                        'sectionName' => null,
                        'invoiceNo' => null,
                        'studentName' => null,
                        'fatherName' => null,
                        'month' => null,
                        'academicYear' => null,
                        'fee' => null,
                        'waiver' => null,
                        'totalDue' => null,
                    ]
                ];
            }
        }



        return $this->response
            ->withType('application/json')
            ->withStringBody(json_encode($return_data));
    }
    private function get_gateway_info($userId)
    {
        $gateways = TableRegistry::getTableLocator()->get('acc_gateways');
        $gateway = $gateways->find()
            ->enableAutoFields(true)
            ->enableHydration(false)
            ->where(['name' => $userId])
            ->toArray();
        return $gateway;
    }
    public function payment()
    {
        $this->autoRender = false;
        if ($this->request->is(['post'])) {
            $data = $this->request->getData();

            $gateway_info = $this->get_gateway_info($data['userId']);
            $password = $gateway_info[0]['mfs_key'] . $data['trId'] . $data['invoiceNo'];


            if ($data['userId'] == $gateway_info[0]['user_id'] && $data['password'] == hash("sha512", $password)) {
                if ($data['status'] == 'APPROVED') {
                    $voucher_data = $this->get_voucher_info($data['invoiceNo']);
                    if ($voucher_data == -1) {
                        $return_data = [
                            'responseCode' => "90",
                            'responseMsg' => 'No Voucher Found',
                        ];
                    } else {
                        if ($voucher_data['payment_status'] == 1) {
                            $return_data = [
                                'responseCode' => "00",
                                'responseMsg' => 'Paid',
                            ];
                        } else {
                            $data['bank_id'] = $gateway_info[0]['bank_id'];
                            $return = $this->complete_transection($data, $voucher_data);
                            if ($return == -1) {
                                $return_data = [
                                    'responseCode' => "90",
                                    'responseMsg' => 'error',
                                ];
                            } else {
                                $return_data = [
                                    'responseCode' => "00",
                                    'responseMsg' => 'SUCCESS',
                                ];
                            }
                        }
                    }
                } else {
                    $return_data = [
                        'responseCode' => "90",
                        'responseMsg' => 'Unknown Status',
                    ];
                }
            } else {
                $return_data = [
                    'responseCode' => 90,
                    'responseMsg' => 'Username and Password do not match',
                ];
            }

            header('Content-Type: application/json');
            echo json_encode($return_data);
        }

    }
    function complete_transection($data, $voucher_data)
    {
        $values = $this->unpaid_voucher_info($voucher_data['sid']);
        $seesion_id = '';
        $amount = 0;
        $level_id = '';
        $month_ids = array();
        $penalty = array();
        foreach ($values as $value) {
            $v_id[] = $value['id'];
            $amount = $amount + $value['amount'];
            $seesion_id = $value['session_id'];
            $level_id = $value['level_id'];
            $month_ids = array_merge($month_ids, json_decode($value['month_ids']));
        }
        if (strtolower($this->get_settings_value('acc_penalty')) == 'on' && count($month_ids)) {
            $currentMonth = date('m');
            if (min($month_ids) < $currentMonth) {
                $penalty = $this->get_penalty($level_id, $seesion_id);
                $amount = $amount + $penalty['total'];
            }
        }
        $transaction_data = $voucher_data;
        $transaction_data['voucher_ids'] = json_encode($v_id);
        $transaction_data['trn_no'] = $this->genarate_transaction_name();
        $transaction_data['due_amount'] = 0;
        unset($transaction_data['id']);
        unset($transaction_data['payment_amount']);
        unset($transaction_data['acc_voucher_create_log_id']);
        unset($transaction_data['voucher_create_by']);
        $studnet_data = $this->get_student_data($voucher_data['sid']);
        $bank_id = intval($data['bank_id']);
        $acc_banks = TableRegistry::getTableLocator()->get('acc_banks');
        $banks = $acc_banks->find()
            ->enableAutoFields(true)
            ->enableHydration(false)
            ->where(['bank_id' => $bank_id])
            ->toArray();
        if (count($banks)) {
            $bank_balance_update['bank_balance'] = $banks[0]['bank_balance'] + $data['tr_amount'];
            $query = $acc_banks->query();
            $query->update()
                ->set($bank_balance_update)
                ->where(['bank_id' => $bank_id])
                ->execute();

            $t_data['trn_no'] = $transaction_data['trn_no'];
            $t_data['voucher_ids'] = $transaction_data['voucher_ids'];
            $t_data['amount'] = $amount;
            $t_data['bank_id'] = $bank_id;
            $t_data['transaction_type'] = 'credit';
            $t_data['type'] = 'school_fees';
            $t_data['student_cycle_id'] = $transaction_data['student_cycle_id'];
            $t_data['level_id'] = $transaction_data['level_id'];
            $t_data['sid'] = $transaction_data['sid'];
            $t_data['session_id'] = $transaction_data['session_id'];
            $t_data['month_ids'] = json_encode($month_ids);
            $t_data['payment_status'] = 1;
            $t_data['payment_date'] = $data['date_time'];
            $t_data['payment_trID'] = $data['trId'];
            $t_data['payment_tr_amount'] = $data['tr_amount'];
            $t_data['payment_cr_amount'] = $data['cr_amount'];
            $t_data['user_id'] = 1;

            $insert_data[0] = $t_data;

            $acc_transactions = TableRegistry::getTableLocator()->get('acc_transactions');
            $insertQueryResult = $acc_transactions->query();
            $columns = array_keys($insert_data[0]);
            $insertQueryResult->insert($columns);
            $insertQueryResult->clause('values')->values($insert_data);
            $insertQueryResult->execute();
            $myrecords = $acc_transactions->find()->last();
            $last_id = $myrecords->transaction_id;

            $this->update_vouchers_data($last_id, $values, $penalty);
            if ($studnet_data['mobile'] || $studnet_data['father_mobile']) {
                $words = explode(" ", $this->get_settings_value('Site.title'));
                $initials = "";
                foreach ($words as $word) {
                    if (!empty($word)) {
                        $initials .= strtoupper($word[0]);
                    }
                }
                $mobile = $studnet_data['mobile'] ? $studnet_data['mobile'] : $studnet_data['father_mobile'];
                $recipients[] = $mobile;
                $args['sms'] = "Your payment (Name: " . $studnet_data['name'] . ") of TK " . $data['tr_amount'] . " has successfully been received.
Headmaster, " .
                    $initials;
                $this->send_sms('online_payment', $recipients, $args);
            }
        } else {
            return -1;
        }
    }
    private function genarate_transaction_name()
    {
        ##GENERATE VOUCHER CODE for THE TRANSACTIONS
        $acc_transactions_name = TableRegistry::getTableLocator()->get('acc_transactions_name');
        $Prefix = 'TRN';
        $yearMonth = date('Ym');

        $trn = $acc_transactions_name->find()->order(['id' => 'DESC'])->first();
        if (empty($trn)) {
            // If there are no existing voucher records, start with 'VN000001'
            $TrnCode = $Prefix . $yearMonth . '000001';
        } else {
            // Extract the numeric part of the last voucher number and increment it
            $lastTrn = $trn->transactions_name;
            $numericPart = substr($lastTrn, -6);
            $datePart = substr($lastTrn, 3, 4);
            $currentYear = substr($yearMonth, 0, 4);
            $val = $numericPart + 1;
            if ($datePart != $currentYear) {
                $TrnCode = $Prefix . $yearMonth . '000001';
            } else {
                if ($val > 999999) {
                    // If it exceeds, simply append the numeric value after the prefix
                    $TrnCode = $Prefix . $yearMonth . $val;
                } else {
                    // If it doesn't exceed, format it with leading zeros
                    $TrnCode = $Prefix . $yearMonth . sprintf("%06d", $val);
                }
            }
        }
        $data['transactions_name'] = $TrnCode;
        $query = $acc_transactions_name->query();
        $query->insert(['transactions_name'])->values($data)->execute();
        return $TrnCode;
    }

    function update_vouchers_data($transaction_id, $vouchers, $penalty)
    {
        $ids = null;
        $filter_voucher = array();
        foreach ($vouchers as $voucher) {
            $filter_voucher[$voucher['id']] = $voucher;
            $ids[] = $voucher['id'];
        }
        $acc_voucher_purposes = TableRegistry::getTableLocator()->get('acc_voucher_purposes');
        $voucher_purposes = $acc_voucher_purposes->find()
            ->enableAutoFields(true)
            ->enableHydration(false)
            ->where(['voucher_id IN' => $ids])
            ->toArray();
        $transaction_purposes_data_all = array();
        foreach ($voucher_purposes as $row) {
            $transaction_purposes_data['transaction_id'] = $transaction_id;
            $transaction_purposes_data['voucher_id'] = $row['voucher_id'];
            $transaction_purposes_data['purpose_id'] = $row['purpose_id'];
            $transaction_purposes_data['month_id'] = $row['month_id'];
            if ($filter_voucher[$row['voucher_id']]['payment_status'] == 2) {
                $transaction_purposes_data['amount'] = $row['due'];
                $v_payment_amount = $row['payment_amount'] + $row['due'];

                $voucher_purposes_update['payment_amount'] = $v_payment_amount;
                $voucher_purposes_update['due'] = 0;
                $voucher_purposes_update['payment_status'] = 1;
                $voucher_purposes_update['paid_transaction_id'] = $transaction_id;

                $query = $acc_voucher_purposes->query();
                $query->update()
                    ->set($voucher_purposes_update)
                    ->where(['voucher_purpose_id' => $row['voucher_purpose_id']])
                    ->execute();
            } else if ($filter_voucher[$row['voucher_id']]['payment_status'] == 0) {
                $transaction_purposes_data['amount'] = $row['amount'];
                $v_payment_amount = $row['amount'];

                $voucher_purposes_update['payment_amount'] = $v_payment_amount;
                $voucher_purposes_update['payment_status'] = 1;
                $voucher_purposes_update['paid_transaction_id'] = $transaction_id;
                $query = $acc_voucher_purposes->query();
                $query->update()
                    ->set($voucher_purposes_update)
                    ->where(['voucher_purpose_id' => $row['voucher_purpose_id']])
                    ->execute();
            }
            if (isset($penalty['penalty']) && count($penalty['penalty'])) {
                if (isset($penalty['penalty'][$row['purpose_id']])) {
                    $transaction_purposes_data['amount'] = $transaction_purposes_data['amount'] + $penalty['penalty'][$row['purpose_id']];
                    unset($penalty['penalty']);
                }
            }
            $transaction_purposes_data_all[] = $transaction_purposes_data;
        }
        if (isset($penalty['penalty']) && count($penalty['penalty'])) {
            foreach ($penalty['penalty'] as $key => $value) {
                $transaction_purposes_data['purpose_id'] = $key;
                $transaction_purposes_data['amount'] = $value;
            }
            $transaction_purposes_data_all[] = $transaction_purposes_data;
        }


        if (count($transaction_purposes_data_all)) {
            $acc_transaction_purposes = TableRegistry::getTableLocator()->get('acc_transaction_purposes');
            $insertQueryResult = $acc_transaction_purposes->query();
            $columns = array_keys($transaction_purposes_data_all[0]);
            $insertQueryResult->insert($columns);
            $insertQueryResult->clause('values')->values($transaction_purposes_data_all);
            $insertQueryResult->execute();
        }
        $months = array();
        $acc_vouchers = TableRegistry::getTableLocator()->get('acc_vouchers');
        foreach ($vouchers as $voucher_data) {
            if ($voucher_data['payment_status']) {
                $payment_amount = $voucher_data['payment_amount'] + $voucher_data['due_amount'];
            } else {
                $payment_amount = $voucher_data['amount'];
            }
            $voucher_update['payment_amount'] = $payment_amount;
            $voucher_update['due_amount'] = 0;
            $voucher_update['payment_status'] = 1;
            $query = $acc_vouchers->query();
            $query->update()
                ->set($voucher_update)
                ->where(['id' => $voucher_data['id']])
                ->execute();
            $months = array_merge($months, json_decode($voucher_data['month_ids']));
        }

        $paid_month_data['transaction_id'] = $transaction_id;
        $paid_month_data['student_cycle_id'] = $voucher_data['student_cycle_id'];
        $paid_month_data['session_id'] = $voucher_data['session_id'];
        $paid_month_data_all = array();
        foreach ($months as $month) {
            $paid_month_data['month_id'] = $month;
            $paid_month_data_all[] = $paid_month_data;
        }
        if (count($paid_month_data_all)) {
            $acc_student_month_paid = TableRegistry::getTableLocator()->get('acc_student_month_paid');
            $insertQueryResult = $acc_student_month_paid->query();
            $columns = array_keys($paid_month_data_all[0]);
            $insertQueryResult->insert($columns);
            $insertQueryResult->clause('values')->values($paid_month_data_all);
            $insertQueryResult->execute();
        }

    }
    function get_voucher_info($voucher_no)
    {
        $acc_vouchers = TableRegistry::getTableLocator()->get('acc_vouchers');
        $vouchers = $acc_vouchers
            ->find()
            ->enableAutoFields(true)
            ->enableHydration(false)
            ->where(['voucher_no' => $voucher_no])
            ->toArray();
        if (count($vouchers)) {
            return $vouchers[0];
        } else {
            return -1;
        }
    }
    private function get_month_name($months)
    {
        $month_ids = json_decode($months);
        $month = TableRegistry::getTableLocator()->get('acc_months');
        $get_months = $month
            ->find()
            ->enableAutoFields(true)
            ->enableHydration(false)
            ->where(['id IN' => $month_ids])
            ->toArray();
        foreach ($get_months as $get_month) {
            if (isset($name)) {
                $name = $name . ', ' . substr($get_month['month_name'], 0, 3);
            } else {
                $name = substr($get_month['month_name'], 0, 3);
            }
        }
        return $name;
    }
    function get_student_data($sid)
    {
        $values = $this->unpaid_voucher_info($sid);
        $month_ids_all = array();
        $amount = 0;
        $seesion_id = '';
        $level_id = '';
        if (count($values)) {
            foreach ($values as $value) {
                $month_ids = json_decode($value['month_ids']);
                $month_ids_all = array_merge($month_ids_all, $month_ids);
                if ($value['payment_status'] == 2 && $value['due_amount'] > 0) {
                    $amount = $amount + $value['due_amount'];
                } else {
                    $amount = $amount + $value['amount'];
                }
                $level_id = $value['level_id'];
                $seesion_id = $value['session_id'];
            }
        } else {
            return -1;
        }
        if (strtolower($this->get_settings_value('acc_penalty')) == 'on' && count($month_ids_all)) {
            $currentMonth = date('m');
            if (min($month_ids_all) < $currentMonth) {
                $penalty = $this->get_penalty($level_id, $seesion_id);
                $amount = $amount + $penalty['total'];
            }
        }
        $return = $value;
        $month = TableRegistry::getTableLocator()->get('acc_months');
        $get_months = $month
            ->find()
            ->enableAutoFields(true)
            ->enableHydration(false)
            ->where(['id IN' => $month_ids_all])
            ->toArray();
        foreach ($get_months as $get_month) {
            if (isset($month_name)) {
                $month_name = $month_name . ', ' . substr($get_month['month_name'], 0, 3);
            } else {
                $month_name = substr($get_month['month_name'], 0, 3);
            }
        }
        $return['months_name'] = $month_name;
        $return['amount'] = $amount;
        unset($return['month_ids']);
        $return['amount'] = number_format((float) $return['amount'], 2, '.', '');
        return $return;
    }
    public function get_penalty($level_id, $seesion_id)
    {
        $acc_penalty = TableRegistry::getTableLocator()->get('acc_penalty');
        $penalty = $acc_penalty->find()
            ->enableHydration(false)
            ->enableAutoFields(true)
            ->where(['level_id' => $level_id])
            ->where(['session_id' => $seesion_id])
            ->toArray();
        $return['total'] = 0;
        $return['penalty'] = array();
        foreach ($penalty as $p) {
            $return['total'] = $return['total'] + $p['amount'];
            if (isset($return['penalty'][$p['purpose_id']])) {
                $return['penalty'][$p['purpose_id']] = $return['penalty'][$p['purpose_id']] + $p['amount'];
            } else {
                $return['penalty'][$p['purpose_id']] = $p['amount'];
            }
        }
        return $return;
    }

    private function unpaid_voucher_info($sid)
    {
        $data = TableRegistry::getTableLocator()->get('acc_vouchers');
        $vouchers = $data->find()
            ->where(['acc_vouchers.sid' => $sid])
            ->where(['acc_vouchers.payment_status !=1'])
            ->where(['acc_vouchers.deleted' => 0])
            ->enableAutoFields(true)
            ->enableHydration(false)->select([
                    'student_cycle_id' => 'scms_student_cycle.student_cycle_id',
                    'id' => 'acc_vouchers.id',
                    'session_id' => 'scms_sessions.session_id',
                    'mobile' => 'active.mobile',
                    'father_mobile' => 'father.mobile',
                    'payment_status' => 'acc_vouchers.payment_status',
                    'due_amount' => 'acc_vouchers.due_amount',
                    'month_ids' => 'acc_vouchers.month_ids',
                    'amount' => 'acc_vouchers.amount',
                    'voucher_no' => 'acc_vouchers.voucher_no',
                    'father_name' => 'father.name',
                    'student_sid' => 'scms_students.sid',
                    'section_name' => 'scms_sections.section_name',
                    'name' => "scms_students.name",
                    'level_name' => "scms_levels.level_name",
                    'session_name' => "scms_sessions.session_name",
                ])->order(['acc_vouchers.id' => 'DESC'])
            ->group('acc_vouchers.id')
            ->join([
                'scms_student_cycle' => [
                    'table' => 'scms_student_cycle',
                    'type' => 'INNER',
                    'conditions' => [
                        'scms_student_cycle.student_cycle_id  = acc_vouchers.student_cycle_id',
                    ]
                ],
                'scms_students' => [
                    'table' => 'scms_students',
                    'type' => 'INNER',
                    'conditions' => [
                        'scms_student_cycle.student_id = scms_students.student_id'
                    ]
                ],
                'scms_levels' => [
                    'table' => 'scms_levels',
                    'type' => 'INNER',
                    'conditions' => [
                        'acc_vouchers.level_id = scms_levels.level_id'
                    ]
                ],
                'scms_sessions' => [
                    'table' => 'scms_sessions',
                    'type' => 'INNER',
                    'conditions' => [
                        'acc_vouchers.session_id = scms_sessions.session_id'
                    ]
                ],
                'scms_sections' => [
                    'table' => 'scms_sections',
                    'type' => 'INNER',
                    'conditions' => [
                        'scms_student_cycle.section_id = scms_sections.section_id'
                    ]
                ],
                'father' => [
                    'table' => 'scms_guardians',
                    'type' => 'LEFT',
                    'conditions' => [
                        'father.student_id = scms_students.student_id',
                        'father.rtype' => 'Father'
                    ]
                ],
                'active' => [
                    'table' => 'scms_guardians',
                    'type' => 'LEFT',
                    'conditions' => [
                        'active.student_id = scms_students.student_id',
                        'active.rtype' => 'scms_students.active_guardian'
                    ]
                ],
            ])->toArray();
        $session_ids = array();
        foreach ($vouchers as $voucher) {
            $session_ids[] = $voucher['session_id'];
        }
        $session_ids = array_unique($session_ids);
        if (count($session_ids)) {
            $minimum_value = min($session_ids);
            foreach ($vouchers as $key => $val) {
                if ($val['session_id'] != $minimum_value) {
                    unset($vouchers[$key]);
                }
            }
        }
        return $vouchers;
    }

}
