<?php

namespace Croogo\Core\Controller\Api;

use Cake\Controller\Component\AuthComponent;
use Cake\Controller\Controller;
use Cake\Core\Configure;
use Cake\Core\Plugin;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;

/**
 * Base Api Controller
 *
 */
class AppController extends Controller
{


    /**
     * Initialize
     *
     * @return void
     */
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('RequestHandler');
    }

    /**
     * beforeFilter
     *
     * @return void
     */
    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);

        if (
            Configure::read('Site.status') == 0 &&
            $this->Auth->user('role_id') != 1
        ) {
            if (!$this->getRequest()->is('whitelisted')) {
                $this->response->statusCode(503);
            }
        }
    }
    protected function get_settings_value($key)
    {
        $setting = TableRegistry::getTableLocator()->get('settings');
        $settings = $setting
            ->find()
            ->where(['`key`' => $key])
            ->toArray();
        return isset($settings[0]['value']) ? $settings[0]['value'] : null;
    }
    private function cheak_sms()
    {
        $setting = TableRegistry::getTableLocator()->get('settings');
        $settings = $setting
            ->find()
            ->where(['`key`' => 'SMS.SMS_status'])
            ->toArray();
        if (($settings[0]['value']) == 'ON') {
            return true;
        } else {
            return false;
        }
    }
    private function sms_minus($total_sms)
    {
        $setting = TableRegistry::getTableLocator()->get('settings');
        $settings = $setting
            ->find()
            ->where(['`key`' => 'SMS.SMS_Credit'])
            ->toArray();
        $new['value'] = $settings[0]['value'] - $total_sms;
        $query = $setting->query();
        $query->update()
            ->set($new)
            ->where(['`key`' => 'SMS.SMS_Credit'])
            ->execute();

        $count = $setting
            ->find()
            ->where(['`key`' => 'SMS.SMS_Count'])
            ->toArray();
        $new_count['value'] = $count[0]['value'] + $total_sms;
        $query1 = $setting->query();
        $query1->update()
            ->set($new_count)
            ->where(['`key`' => 'SMS.SMS_Count'])
            ->execute();
    }

    private function sms_log($data)
    {
        $sms_log = TableRegistry::getTableLocator()->get('sms_log');
        $query = $sms_log->query();
        $data['number_of_sms'] = $data['sms_count'] / $data['segment'];
        $query->insert(['sms_count', 'sms_type', 'user_id', 'sms', 'segment', 'number_of_sms'])
            ->values($data)
            ->execute();
    }
    protected function send_sms($type, $recipients, $args = array())
    {
        if ($this->cheak_sms()) {
            $apikey = Configure::read('SMS.API_Key');
            $secretkey = Configure::read('SMS.Secret_Key');
            $callerID = Configure::read('SMS.CallerID');
            $instituteTag = Configure::read('SMS.SMS_institute_tag');
            $smsFooter = "\n" . $instituteTag;
            $result = 0;

            if ($type == 'online_payment') {
                $message = $args['sms'];
                $result = $this->send_reve_single($recipients, $message, $apikey, $secretkey, $callerID);
                $log['sms_count'] = $result;
                $log['sms_type'] = $type;
                $log['user_id'] = 1;
                $log['sms'] = $message;
                $log['segment'] = $this->multipart_count($log['sms']);
                $log['number_of_sms'] = count($recipients);
                $this->sms_log($log);
                return $result;

                foreach ($args['students'] as $k => $studnet) {
                    // echo '<pre>';
                    // print_r($studnet);
                    // die;

                    $messages[$k]['callerID'] = $callerID;
                    $messages[$k]['toUser'] = preg_replace('/^[0]/', '88$0', $studnet['mobile']);
                    $messages[$k]['messageContent'] = "Dear Parent,\nPlease be informed that " . strtoupper($studnet['name']) . " SID: " . strtoupper($studnet['sid']) . " has " . number_format($studnet['amount'], 0) . " tk Due." . $smsFooter;
                    /* $messages[$k]['messageContent'] = "Dear Parent,\nPlease be informed that " . $studnet['name'] . "\n"
                     . "SID: " . $studnet['sid'] . "\n"
                     . "Pay Amount: " . number_format($studnet['amount'], 0) . " Tk.\n"
                     . "through Rocket Mobile Banking.\n" 
                     . "School Biller ID: 5276 (Rocket)\n" 
                     . "For the payment procedure, please visit our website (www.dgghs.edu.bd) "  
                     . $smsFooter; */


                }
                // echo '<pre>';
                // print_r($messages);
                // die;
                if ($this->cheak_sms_count($messages)) {
                    $result = $this->send_reve_multi($messages, $apikey, $secretkey);
                    $log['sms'] = $messages[$k]['messageContent'];
                    $log['segment'] = $this->multipart_count($log['sms']);
                    $log['number_of_sms'] = count($messages) + $headCount;
                    $log['sms_count'] = $result + ($headCount * $log['segment']);
                    $headfooter = "\n\nTotal SMS Sent:" . $log['sms_count'];
                }



                $this->sms_minus($result);
                $log['sms_type'] = $type;
                $log['segment'] = $this->multipart_count($log['sms']);
                $log['sms_count'] = $result;
                $log['user_id'] = $this->Auth->user('id');
                $this->sms_log($log);
                return $result;
            } else {
                echo 'SMS Service is Unavailable';
                return 0;
            }

        }
    }

    private function send_reve_single($recipients, $message, $apikey, $secretkey, $callerID)
    {
        if (!is_array($recipients))
            $recipients = explode(',', $recipients);
        $recipients = array_map('trim', $recipients);
        $recipients = array_values(array_unique(preg_replace('/^[0]/', '88$0', $recipients)));

        $url = "https://smpp.revesms.com:7790/sendtext";

        $dataformat = [
            "apikey" => $apikey,
            "secretkey" => $secretkey,
            "callerID" => $callerID,
            "toUser" => "",
            "messageContent" => str_replace("\r", "", $message)
        ];

        $datas = array();
        for ($i = 0; $i < count($recipients); $i++) {
            $dataformat["toUser"] .= $recipients[$i] . ",";
            if (strlen($url . '?' . http_build_query($dataformat)) > 8000) {
                $dataformat["toUser"] = rtrim($dataformat["toUser"], ',');
                $datas[] = $dataformat;
                $dataformat["toUser"] = '';
            }
        }
        if ($dataformat["toUser"] != '') {
            $dataformat["toUser"] = rtrim($dataformat["toUser"], ',');
            $datas[] = $dataformat;
        }

        $tatal_sent = 0;

        foreach ($datas as $data) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url . '?' . http_build_query($data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
            $headers = array();
            $headers[] = "Key: Value";
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_SSL_CIPHER_LIST, 'DEFAULT:!DH');
            $result = json_decode(curl_exec($ch));

            if (curl_errno($ch)) {
                echo 'Error:' . curl_error($ch);
            }
            curl_close($ch);

            if ($result->Status == 0) {
                $sms_sent = count(explode(',', $result->Message_ID));
                $tatal_sent += $sms_sent * $this->multipart_count($message);
            }
        }
        return $tatal_sent;
    }
    private function multipart_count($str)
    {
        $one_part_limit = 160; // use a constant i.e. GSM::SMS_SINGLE_7BIT
        $multi_limit = 153; // again, use a constant
        $max_parts = 6; // ... constant

        $str_length = $this->count_gsm_string($str);
        if ($str_length === -1) {
            $one_part_limit = 70; // ... constant
            $multi_limit = 67; // ... constant
            $str_length = $this->count_ucs2_string($str);
        }

        if ($str_length <= $one_part_limit) {
            // fits in one part
            return 1;
        } elseif ($str_length > ($max_parts * $multi_limit)) {
            // too long
            return -1; // or throw exception, or false, etc.
        } else {
            // divide the string length by multi_limit and round up to get number of parts
            return ceil($str_length / $multi_limit);
        }
    }

    private function count_gsm_string($str)
    {
        // Basic GSM character set (one 7-bit encoded char each)
        $gsm_7bit_basic = "@£$¥èéùìòÇ\nØø\rÅåΔ_ΦΓΛΩΠΨΣΘΞÆæßÉ !\"#¤%&'()*+,-./0123456789:;<=>?¡ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÑÜ§¿abcdefghijklmnopqrstuvwxyzäöñüà";

        // Extended set (requires escape code before character thus 2x7-bit encodings per)
        $gsm_7bit_extended = "^{}\\[~]|€";

        $len = 0;

        for ($i = 0; $i < mb_strlen($str); $i++) {
            $c = mb_substr($str, $i, 1);
            if (mb_strpos($gsm_7bit_basic, $c) !== FALSE) {
                $len++;
            } else if (mb_strpos($gsm_7bit_extended, $c) !== FALSE) {
                $len += 2;
            } else {
                return -1; // cannot be encoded as GSM, immediately return -1
            }
        }

        return $len;
    }

    private function count_ucs2_string($str)
    {
        $utf16str = mb_convert_encoding($str, 'UTF-16', 'UTF-8');
        // C* option gives an unsigned 16-bit integer representation of each byte
        // which option you choose doesn't actually matter as long as you get one value per byte
        $byteArray = unpack('C*', $utf16str);
        return count($byteArray) / 2;
    }
}
