<?php

namespace Croogo\Blocks\Test\Fixture;

use Croogo\Core\TestSuite\CroogoTestFixture;

class BlockFixture extends CroogoTestFixture
{

    public $fields = [
        'id' => ['type' => 'integer', 'null' => false, 'default' => null, 'length' => 20],
        'region_id' => ['type' => 'integer', 'null' => true, 'default' => null, 'length' => 20],
        'title' => ['type' => 'string', 'null' => false, 'default' => null, 'length' => 100],
        'alias' => ['type' => 'string', 'null' => true, 'default' => null, 'length' => 100],
        'body' => ['type' => 'text', 'null' => true, 'default' => null],
        'show_title' => ['type' => 'boolean', 'null' => false, 'default' => '1'],
        'class' => ['type' => 'string', 'null' => true, 'default' => null],
        'status' => ['type' => 'integer', 'length' => 1, 'null' => false, 'default' => '0'],
        'weight' => ['type' => 'integer', 'null' => true, 'default' => null],
        'element' => ['type' => 'string', 'null' => true, 'default' => null],
        'visibility_roles' => ['type' => 'text', 'null' => true, 'default' => null],
        'visibility_paths' => ['type' => 'text', 'null' => true, 'default' => null],
        'visibility_php' => ['type' => 'text', 'null' => true, 'default' => null],
        'params' => ['type' => 'text', 'null' => true, 'default' => null],
        'publish_start' => ['type' => 'datetime', 'null' => true, 'default' => null],
        'publish_end' => ['type' => 'datetime', 'null' => true, 'default' => null],
        'updated' => ['type' => 'datetime', 'null' => false, 'default' => null],
        'created' => ['type' => 'datetime', 'null' => false, 'default' => null],
        '_constraints' => [
            'primary' => ['type' => 'primary', 'columns' => ['id']],
            'alias' => ['type' => 'unique', 'columns' => 'alias']
        ],
        '_options' => ['charset' => 'utf8', 'collate' => 'utf8_unicode_ci', 'engine' => 'InnoDB']
    ];

    public $records = [
        [
            'id' => 3,
            'region_id' => 4,
            'title' => 'About',
            'alias' => 'about',
            'body' => 'This is the content of your block. Can be modified in admin panel.',
            'show_title' => 1,
            'class' => null,
            'status' => 1,
            'weight' => 2,
            'element' => null,
            'visibility_roles' => null,
            'visibility_paths' => null,
            'visibility_php' => null,
            'params' => null,
            'updated' => '2009-12-20 03:07:39',
            'created' => '2009-07-26 17:13:14'
        ],
        [
            'id' => 8,
            'region_id' => 4,
            'title' => 'Search',
            'alias' => 'search',
            'body' => null,
            'show_title' => 0,
            'class' => null,
            'status' => 1,
            'weight' => 1,
            'element' => 'Nodes.search',
            'visibility_roles' => null,
            'visibility_paths' => null,
            'visibility_php' => null,
            'params' => null,
            'updated' => '2009-12-20 03:07:39',
            'created' => '2009-12-20 03:07:27'
        ],
        [
            'id' => 5,
            'region_id' => 4,
            'title' => 'Meta',
            'alias' => 'meta',
            'body' => '[menu:meta]',
            'show_title' => 1,
            'class' => null,
            'status' => 1,
            'weight' => 6,
            'element' => null,
            'visibility_roles' => null,
            'visibility_paths' => null,
            'visibility_php' => null,
            'params' => null,
            'updated' => '2009-12-22 05:17:39',
            'created' => '2009-09-12 06:36:22'
        ],
        [
            'id' => 6,
            'region_id' => 4,
            'title' => 'Blogroll',
            'alias' => 'blogroll',
            'body' => '[menu:blogroll]',
            'show_title' => 1,
            'class' => null,
            'status' => 1,
            'weight' => 4,
            'element' => null,
            'visibility_roles' => null,
            'visibility_paths' => null,
            'visibility_php' => null,
            'params' => null,
            'updated' => '2009-12-20 03:07:33',
            'created' => '2009-09-12 23:33:27'
        ],
        [
            'id' => 7,
            'region_id' => 4,
            'title' => 'Categories',
            'alias' => 'categories',
            'body' => '[vocabulary:categories type=\"blog\"]',
            'show_title' => 1,
            'class' => null,
            'status' => 1,
            'weight' => 3,
            'element' => null,
            'visibility_roles' => null,
            'visibility_paths' => null,
            'visibility_php' => null,
            'params' => null,
            'updated' => '2009-12-20 03:07:36',
            'created' => '2009-10-03 16:52:50'
        ],
        [
            'id' => 9,
            'region_id' => 4,
            'title' => 'Recent Posts',
            'alias' => 'recent_posts',
            'body' => '[node:recent_posts conditions=\"Nodes.type:blog\" order=\"Nodes.id DESC\" limit=\"5\"]',
            'show_title' => 1,
            'class' => null,
            'status' => 1,
            'weight' => 5,
            'element' => null,
            'visibility_roles' => null,
            'visibility_paths' => null,
            'visibility_php' => null,
            'params' => null,
            'updated' => '2010-04-08 21:09:31',
            'created' => '2009-12-22 05:17:32'
        ],
        [
            'id' => 10,
            'region_id' => 4,
            'title' => 'Block Visible by Public',
            'alias' => 'block-visible-by-public',
            'body' => 'Block Visible by Public',
            'show_title' => 1,
            'class' => null,
            'status' => 1,
            'weight' => 7,
            'element' => null,
            'visibility_roles' => '["3"]',
            'visibility_paths' => null,
            'visibility_php' => null,
            'params' => null,
            'updated' => '2010-04-08 21:09:31',
            'created' => '2009-12-22 05:17:32'
        ],
        [
            'id' => 11,
            'region_id' => 4,
            'title' => 'Block Visible by Admin or Registered',
            'alias' => 'block-visible-by-admin-or-registered',
            'body' => 'Block Visible by Admin or Registered',
            'show_title' => 1,
            'class' => null,
            'status' => 1,
            'weight' => 8,
            'element' => null,
            'visibility_roles' => '["1","2"]',
            'visibility_paths' => null,
            'visibility_php' => null,
            'params' => null,
            'updated' => '2010-04-08 21:09:31',
            'created' => '2009-12-22 05:17:32'
        ],
    ];
}
